function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 22);

T(1) = (params(2)-1)/params(2);
T(2) = exp(T(1)*y(42));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(37))^(1-params(3));
T(5) = T(3)*T(4);
T(6) = T(5)^T(1);
T(7) = (1-params(11))*T(2)*T(6)+params(11)*exp(y(32))^T(1);
T(8) = exp(y(35))^(1/params(2));
T(9) = (-1)/params(2);
T(10) = exp(y(32))^T(9);
T(11) = T(5)^T(9);
T(12) = exp(y(37))^(-params(3));
T(13) = exp(y(13))^(params(3)-1);
T(14) = params(9)^((-1)/params(8));
T(15) = exp(y(57));
T(16) = exp(y(38))-params(9)*exp(y(37))^(1+params(8))/(1+params(8));
T(17) = params(1)*T(16)^(-params(14));
T(18) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(19) = T(18)^(-params(14));
T(20) = params(13)^(1-params(4));
T(21) = T(15)*(exp(y(51))*exp((-y(58)))*exp(y(27))+(1-exp((-y(58)))*exp(y(27)))*y(54)-params(6)*exp(params(5)*(y(27)-y(58))));
T(22) = params(12)^(1-params(4));

end
